define([
    'backbone',
    'Layout',
    'modules/new-appointment-request/views/common/email/section-view',
],
function(Backbone, Layout, EmailPreferencesSectionView) {
    'use strict';

    // TODO move to test folder
    describe('Email Preferences Section', function() {
        var view;
        var model;
        var $view;
        var layout;


        beforeEach(function() {
            layout = new Layout();
            layout.render();
            model = new Backbone.Model();
            spyOn(EmailPreferencesSectionView.prototype, 'goToNotificationInfo').and.callThrough();

            view = new EmailPreferencesSectionView({model: model});

            layout.showChildView('fDNS   tent', view);
            $view = view.$el;
        });

        it('correct section legend text is set', function() {
            expect($view.find("legend[class='form-section-heading']").text()).toEqual('Email Preferences');
        });

        it('template gets appended to legend', function() {
            expect($view.find("legend[for='emailAllowed'] #notification-info-btn").length).toEqual(1);
            expect($view.find("legend[for='emailAllowed'] #notification-info-btn > span").text()).toEqual('Information about updates on my appointments and requests');
        });

        describe('when notification info button is clicked', function() {

            it('calls goToNotificationInfo when button is clicked', function() {
                $view.find('#notification-info-btn').click();
                expect(view.goToNotificationInfo).toHaveBeenCalled();
            });
        });
        describe('overrideInitialize', function() {
            it('sets the legend and email allowed for cc request', function() {
                view.overrideInitialize({isForCommunityCare: true});
                expect(view.legend).toEqual('VA Scheduling Notifications');
                expect(view.model.get('emailAllowed')).toEqual(true);
            });
            it('sets the information for ExpressCare', function() {
                view.overrideInitialize({isForExpressCare: true});
                expect(view.legend).toEqual('Notification Settings');
                expect(view.model.get('emailAllowed')).toEqual(true);
                expect(view.collection.get('emailAllowed')).toBeUndefined();
                expect(view.isForVideoVisit).toBeFalsy();
            });
            it('sets the information for VideoVisit', function() {
                view.overrideInitialize({isForVideoVisit: true});
                expect(view.legend).toEqual('Notification Settings');
                expect(view.model.get('emailAllowed')).toEqual(true);
                expect(view.collection.get('emailAllowed')).toBeUndefined();
                expect(view.isForVideoVisit).toBeTruthy();
            });
        });
    });
});
